% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{readPng}
\alias{readPng}
\alias{print.loder}
\title{Read a PNG file}
\usage{
readPng(file)

\method{print}{loder}(x, ...)
}
\arguments{
\item{file}{A character string giving the file name to read from.}

\item{x}{An object of class \code{"loder"}.}

\item{...}{Additional arguments (which are ignored).}
}
\value{
\code{readPng} returns an integer-mode array of class
  \code{"loder"}. The \code{print} method is called for its side-effect.
}
\description{
Read an image from a PNG file and convert the pixel data into an R array.
}
\details{
The LodePNG library is used to read the PNG file at the specified path.
LodePNG can handle a wide variety of subformats and bit depths, but the
output of this function is currently standardised to an integer-mode array
with 8-bit range, i.e. between 0 and 255. Attributes specifying the
background colour, spatial resolution and/or aspect ratio are attached to
the result if this information is stored with the image.
}
\examples{
path <- system.file("extdata", "pngsuite", package="loder")
image <- readPng(file.path(path, "basn6a08.png"))
print(image)
attributes(image)

}
\seealso{
\code{inspectPng} to read only metadata from the file. In addition,
  the \code{readPNG} function in the venerable \code{png} package offers
  similar functionality to \code{readPng}, but relies on an external
  installation of libpng. By contrast, \code{loder} includes the LodePNG
  library.
}
