% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_recomb.R
\name{link_recomb}
\alias{link_recomb}
\title{Query UCSC for Recombination data}
\usage{
link_recomb(loc, genome = "hg38", table = NULL, recomb = NULL)
}
\arguments{
\item{loc}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}}

\item{genome}{Either \code{"hg38"} or \code{"hg19"}}

\item{table}{Optional character value specifying which recombination table to
use.}

\item{recomb}{Optional \code{GRanges} class object of recombination data.}
}
\value{
A list object of class 'locus'. Recombination data is added as list
element \code{recomb}.
}
\description{
Adds recombination data to a 'locus' object by querying UCSC genome browser.
}
\details{
Uses the \code{rtracklayer} package to query UCSC genome browser for recombination
rate data.

Possible options for \code{table} for hg19 are \code{"hapMapRelease24YRIRecombMap"},
\code{"hapMapRelease24CEURecombMap"}, \code{"hapMapRelease24CombinedRecombMap"} (the
default). The only option for \code{table} for hg38 is \code{"recomb1000GAvg"} (the
default).

If you are doing many queries, it may be much faster to download the entire
recombination track data (around 30 MB for hg38) from the Recombination Rate
Tracks page at
\href{https://genome.ucsc.edu/cgi-bin/hgTrackUi?g=recombRate2}{UCSC genome browser}.
The link to the hg38 download folder is
\url{http://hgdownload.soe.ucsc.edu/gbdb/hg38/recombRate/} and for hg19 is
\url{http://hgdownload.soe.ucsc.edu/gbdb/hg19/decode/}. These .bw files can be
converted to useable \code{GRanges} objects using \code{rtracklayer::import.bw()} (see
the vignette).

Sometimes \code{rtracklayer} generates intermittent API errors or warnings: try
calling \code{link_recomb()} again. If warnings persist restart your R session.
Errors are handled gracefully using \code{try()} to allow users to wrap
\code{link_recomb()} in a loop without quitting halfway. Error messages are still
shown. Successful API calls are cached using \code{memoise} to reduce API
requests.
}
