% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus_plotly.R
\name{locus_plotly}
\alias{locus_plotly}
\title{Locus plotly}
\usage{
locus_plotly(loc, heights = c(0.6, 0.4), ...)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{heights}{Vector controlling relative height of each panel on 0-1 scale.}

\item{...}{Optional arguments passed to \code{\link[=genetrack_ly]{genetrack_ly()}} to control the gene
tracks.}
}
\value{
A 'plotly' plotting object showing a scatter plot above gene tracks.
}
\description{
Genomic locus plot similar to locuszoom, using plotly.
}
\details{
This is an R/plotly version of locuszoom for exploring regional Manhattan
plots of gene loci. Use \code{\link[=locus]{locus()}} first to generate an object of class
'locus' for plotting. This references a selected Ensembl database for
annotating genes and exons. Hover over the points or gene tracks to reveal
more information.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = "IRF5", flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
locus_plotly(loc)
}
}
\seealso{
\code{\link[=genetrack_ly]{genetrack_ly()}} \code{\link[=locus]{locus()}}
}
