% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HydroScore}
\alias{HydroScore}
\title{Dictionnaire}
\format{
A score function for the 20 amino acid
}
\source{
Kyte & Doolittle (1982) J. Mol. Biol. 157, 105-132
}
\usage{
HydroScore
}
\description{
Provides integer scores related to an hydrophobicity level of each amino acid. This score function is inspired by the Kyte and Doolittle (1982) scale.
}
\examples{
data(HydroScore)
HydroScore
data(Seq219)
Seq219
seqScore=CharSequence2ScoreSequence(Seq219,HydroScore)
seqScore[1:30]
localScoreC(seqScore)$localScore
}
\keyword{datasets}
