% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{ipsi}
\alias{ipsi}
\title{IPSI Function Factory}
\usage{
ipsi(delta)
}
\arguments{
\item{delta}{[\code{numeric(1)}]\cr
A risk ratio between 0 and Inf.}
}
\value{
A shift function.
}
\description{
A function factory that returns a shift function for increasing or decreasing
the probability of exposure when exposure is binary.
}
\examples{
\donttest{
data("iptwExWide", package = "twang")
a <- paste0("tx", 1:3)
baseline <- c("gender", "age")
tv <- list(c("use0"), c("use1"), c("use2"))
lmtp_sdr(iptwExWide, a, "outcome", baseline = baseline, time_vary = tv,
         shift = ipsi(0.5), outcome_type = "continuous", folds = 2)
}
}
\seealso{
\code{\link[=lmtp_tmle]{lmtp_tmle()}}, \code{\link[=lmtp_sdr]{lmtp_sdr()}}, \code{\link[=lmtp_sub]{lmtp_sub()}}, \code{\link[=lmtp_ipw]{lmtp_ipw()}}
}
