% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_highest.R
\name{test_highest}
\alias{test_highest}
\alias{highest_order}
\title{Test the Highest Order Term by ANOVA}
\usage{
test_highest(lm_out)

highest_order(lm_out)
}
\arguments{
\item{lm_out}{The output of
\code{\link[stats:lm]{stats::lm()}}.}
}
\value{
A \code{hierarchical_lm}-class
object, which is the output of
\code{\link[=hierarchical_lm]{hierarchical_lm()}}. Two models
are compared, the original model and
the model with the unique highest
order term removed.
}
\description{
Identify the highest
order terms in a model fitted by
'lm()', and compare this model to a
model with this term removed using
ANOVA.
}
\details{
The function \code{\link[=test_highest]{test_highest()}}
first check if a model fitted by
\code{\link[stats:lm]{stats::lm()}} has a unique highest
order term (e.g., the term \code{x1:x2},
in the model \code{y ~ x1 + x2 + x1:x2}).
If yes, it will fit a model with this
term removed, and then call
\code{\link[=hierarchical_lm]{hierarchical_lm()}} to compare the
original model with this reduced
model.

If the model does not have a unique
highest order term, an error will
be raised.
}
\section{Functions}{
\itemize{
\item \code{test_highest()}: Test the highest order term.

\item \code{highest_order()}: Find the highest order term.

}}
\section{Limitation}{
It relies on terms created by
\code{\link[stats:lm]{stats::lm()}} to determine the order
of each term. If a higher order term
is created manually (e.g.,
\code{I(x1 * x2)}), then it cannot know
that this term is a second order
term.
}

\examples{

dat <- data_test1

lm1 <- lm(y ~ x1 + x2 + cat1*x3, dat)
lm2 <- lm(y ~ x1 + x2*x3 + x4, dat)

test_highest(lm1)
test_highest(lm2)

highest_order(lm1)
highest_order(lm2)

# The followings will yield an error

lm3 <- lm(y ~ x1 + x2 + x3, dat)
summary(lm3)
tryCatch(test_highest(lm3), error = function(e) e)
tryCatch(highest_order(lm3), error = function(e) e)

lm4 <- lm(y ~ x1 + x2*x3 + x4*x5, dat)
summary(lm4)
tryCatch(test_highest(lm4), error = function(e) e)
tryCatch(highest_order(lm4), error = function(e) e)

}
\seealso{
\code{\link[=hierarchical_lm]{hierarchical_lm()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
