% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_argument_linter.R
\name{function_argument_linter}
\alias{function_argument_linter}
\title{Function argument linter}
\usage{
function_argument_linter()
}
\description{
Check that arguments with defaults come last in all function declarations,
as per the tidyverse design guide.

Changing the argument order can be a breaking change. An alternative to changing the argument order
is to instead set the default for such arguments to \code{NULL}.
}
\examples{
# will produce lints
lint(
  text = "function(y = 1, z = 2, x) {}",
  linters = function_argument_linter()
)

lint(
  text = "function(x, y, z = 1, ..., w) {}",
  linters = function_argument_linter()
)

# okay
lint(
  text = "function(x, y = 1, z = 2) {}",
  linters = function_argument_linter()
)

lint(
  text = "function(x, y, w, z = 1, ...) {}",
  linters = function_argument_linter()
)

lint(
  text = "function(y = 1, z = 2, x = NULL) {}",
  linters = function_argument_linter()
)

lint(
  text = "function(x, y, z = 1, ..., w = NULL) {}",
  linters = function_argument_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://design.tidyverse.org/args-data-details.html}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=style_linters]{style}
}
