% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lang.country.R
\name{lang.country}
\alias{lang.country}
\title{Get languages by country}
\usage{
lang.country(x, list = FALSE, official = FALSE,
  glottolog.source = "modified")
}
\arguments{
\item{x}{character vector of the countries (can be written in lower case)}

\item{list}{logical. If TRUE, returns a list of languages, if FALSE return a vector.}

\item{official}{logical. If TRUE, returns a vector of official languages, if FALSE return a vector from Glottolog database.}

\item{glottolog.source}{A character vector that define which glottolog database is used: 'original' or 'modified' (by default)}
}
\description{
Takes any vector of countries and return languages.
}
\examples{
lang.country('North Korea')
lang.country(c('North Korea', 'Luxembourg'))
lang.country(c('North Korea', 'Luxembourg'), list = TRUE)
lang.country(c('Germany', 'Luxembourg'), official = TRUE)

}
\seealso{
\code{\link{lang.aff}}, \code{\link{lang.iso}}
}
\author{
George Moroz <agricolamz@gmail.com>
}
