% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.dic.R
\name{read.dic}
\alias{read.dic}
\alias{write.dic}
\title{Read/Write Dictionary Files}
\usage{
read.dic(path, cats, type = "asis", as.weighted = FALSE,
  dir = getOption("lingmatch.dict.dir"), ..., term.name = "term",
  category.name = "category", raw = FALSE)

write.dic(dict, filename, type = "asis", as.weighted = FALSE,
  save = TRUE)
}
\arguments{
\item{path}{Path to a file, a name corresponding to a file in \code{getOption('lingmatch.dict.dir')}
(or \code{'~/Dictionaries'}) or one of the dictionaries available at \href{https://osf.io/y6g5b}{osf.io/y6g5b},
a matrix-like object to be categorized, or a list to be formatted.}

\item{cats}{A character vector of category names to be returned. All categories are returned by default.}

\item{type}{A character indicating whether and how terms should be altered. Unspecified or matching 'asis'
leaves terms as they are. Other options change wildcards to regular expressions:
\code{'pattern'} (\code{'^[poi]'}) replaces initial asterisks with \code{'\\\\b\\\\w*'},
and terminal asterisks with \code{'\\\\w*\\\\b'}, to match terms within raw text;
for anything else, terms are padded with \code{^} and \code{$}, then those bounding marks are removed
when an asterisk is present, to match tokenized terms.}

\item{as.weighted}{Logical; if \code{TRUE}, prevents weighted dictionaries from being converted to
unweighted versions, or converts unweighted dictionaries to a binary weighted version
-- a data.frame with a "term" column of unique terms, and a column for each category.}

\item{dir}{Path to a folder containing dictionaries, or where you would like dictionaries to be downloaded;
passed to \code{\link{select.dict}} and/or \code{\link{download.dict}}.}

\item{...}{Passes arguments to \code{\link{readLines}}.}

\item{term.name, category.name}{Strings identifying column names in \code{path} containing terms and categories
respectively.}

\item{raw}{Logical or a character. As logical, indicates if \code{path} should be treated
as a raw dictionary (as might be read in from a .dic file). As a character, replaces \code{path}
as if it were read in from a file.}

\item{dict}{A \code{list} with a named entry of terms for each category, or a \code{data.frame}
with terms in one column, and categories or weights in the rest.}

\item{filename}{The name of the file to be saved.}

\item{save}{Logical: if \code{FALSE}, does not write a file.}
}
\value{
\code{read.dic}: A \code{list} (unweighted) with an entry for each category containing
  character vectors of terms, or a \code{data.frame} (weighted) with columns for terms (first, "term") and
  weights (all subsequent, with category labels as names).

\code{write.dic}: A version of the written dictionary -- a raw character vector for
  unweighted dictionaries, or a \code{data.frame} for weighted dictionaries.
}
\description{
Read in or write dictionary files in Comma-Separated Values (.csv; weighted) or
Linguistic Inquiry and Word Count (.dic; non-weighted) format.
}
\examples{
# make a small murder related dictionary
dict <- list(
  kill = c("kill*", "murd*", "wound*", "die*"),
  death = c("death*", "dying", "die*", "kill*")
)

# convert it to a weighted format
(dict_weighted <- read.dic(dict, as.weighted = TRUE))

# categorize it back
read.dic(dict_weighted)

# convert it to a string without writing to a file
cat(raw_dict <- write.dic(dict, save = FALSE))

# parse it back in
read.dic(raw = raw_dict)

\dontrun{

# save it as a .dic file
write.dic(dict, "murder")

# read it back in as a list
read.dic("murder.dic")

# read in the Moral Foundations or LUSI dictionaries from urls
moral_dict <- read.dic("https://osf.io/download/whjt2")
lusi_dict <- read.dic("https://www.depts.ttu.edu/psy/lusi/files/lusi_dict.txt")

# save and read in a version of the General Inquirer dictionary
inquirer <- read.dic("inquirer", dir = "~/Dictionaries")
}
}
\seealso{
Other Dictionary functions: 
\code{\link{download.dict}()},
\code{\link{lma_patcat}()},
\code{\link{lma_termcat}()},
\code{\link{select.dict}()}
}
\concept{Dictionary functions}
