% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotEGclass.R
\name{plotEGclass}
\alias{plotEGclass}
\title{Plot classifier of eQTL genotype from expression data}
\usage{
plotEGclass(d, eqtl = 1, outercol = "inferred", innercol = "observed",
  thecolors = c("#7B68ED", "#1B9E78", "#CA3767", "#E59E00"), ...)
}
\arguments{
\item{d}{Output of \code{\link{disteg}}.}

\item{eqtl}{Numeric index or a character vector (of the form "1@102.35")
indicating the eQTL to consider.}

\item{outercol}{Indicates how to color the outer edge of the points:
\code{"observed"} indicates to color based on observed genotypes;
\code{"inferred"} indicates to color based on inferred genotypes; otherwise,
give a color.}

\item{innercol}{Like \code{outercol}, but indicating the interior of the
points.}

\item{thecolors}{The colors to use in the plot.  The last element (after the
number of genotypes) indicates the color to use for missing values.}

\item{\dots}{Passed to \code{\link[graphics]{plot}} and
\code{\link[graphics]{points}}.}
}
\value{
None.
}
\description{
Diagnostic plot of one of the eQTL classifiers from the results of
\code{\link{disteg}}: generally expression phenotype against observed eQTL
genotype, colored by inferred eQTL genotype.
}
\details{
The function produces a diagnostic plot for studying one of the k-nearest
neighbor classifiers underlying the output from \code{\link{disteg}}.

In the case of one expression phenotype attached to the selected eQTL, the
plot is a dot plot of gene expression against observed eQTL genotype.

In the case of two expression phenotypes, the plot is a scatterplot of the
two expression phenotypes against each other.

In the case of more than two expression phenotypes, we use
\code{\link[graphics]{pairs}} to produce a matrix of scatterplots.
}
\examples{
library(qtl)

# load example data
data(f2cross, expr1, pmap, genepos)
\dontshow{
keep <- c(1:20, 197, 553, 573, 740, 794, 822, 1474, 1522,
          1591, 1645, 2080, 2643, 2984, 3089, 3672, 4010, 4039,
          4159, 4191, 4198, 4213, 4401, 4544, 4593, 4925)
expr1 <- expr1[,keep]
genepos <- genepos[keep,]}

# calculate QTL genotype probabilities
f2cross <- calc.genoprob(f2cross, step=1)

# find nearest pseudomarkers
pmark <- find.gene.pseudomarker(f2cross, pmap, genepos)

# line up individuals
id <- findCommonID(f2cross, expr1)

# calculate LOD score for local eQTL
locallod <- calc.locallod(f2cross[,id$first], expr1[id$second,], pmark)

# take those with LOD > 25
expr1s <- expr1[,locallod>25,drop=FALSE]

# calculate distance between individuals
#     (prop'n mismatches between obs and inferred eQTL geno)
d <- disteg(f2cross, expr1s, pmark)

# plot of classifier for and second eQTL
par(mfrow=c(2,1), las=1)
plotEGclass(d)
plotEGclass(d, 2)
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{disteg}}, \code{\link{plot.lineupdist}},
\code{\link{plot2dist}}, \code{\link[class]{knn}}
}
\keyword{graphics}

