% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{k1matern52}
\alias{k1matern52}
\title{1D Matern 5/2 Kernel Matrix for \code{"lineqGP"} Models.}
\usage{
k1matern52(x1, x2, par, d = 1)
}
\arguments{
\item{x1}{A vector with the first input locations.}

\item{x2}{A vector with the second input locations.}

\item{par}{Values of the kernel parameters (variance, lengthscale).}

\item{d}{A number corresponding to the dimension of the input space.}
}
\value{
Kernel matrix \eqn{K(x_1,x_2)}{K(x1,x2)}
(or \eqn{K(x_1,x_1)}{K(x1,x1)} if \eqn{x_2}{x2} is not defined).
}
\description{
Compute the 1D Matern 5/2 kernel for \code{"lineqGP"} models.
attr: "gradient", "derivative".
}
\examples{
x <- seq(0, 1, 0.01)
K <- k1matern52(x, x, par =  c(1, 0.1))
image(K, main = "covariance matrix using a Matern 5/2 kernel")

}
\author{
A. F. Lopez-Lopera.
}
