% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_types.R
\name{validate_types}
\alias{validate_types}
\title{Check tagged variables are the right class}
\usage{
validate_types(x, ref_types = tags_types())
}
\arguments{
\item{x}{a \code{linelist} object}

\item{ref_types}{a \code{list} providing allowed types for all tags, as returned
by \code{\link[=tags_types]{tags_types()}}}
}
\value{
A named \code{list}.
}
\description{
This function checks the class of each tagged variable in a \code{linelist}
against pre-defined accepted classes in \code{\link[=tags_types]{tags_types()}}.
}
\examples{
if (require(outbreaks)) {

  ## create an invalid linelist - gender is a numeric
  x <- measles_hagelloch_1861 |>
    make_linelist(
      id = "case_ID",
      gender = "infector"
    )
  x

  ## the below would issue an error
  ## note: tryCatch is only used to avoid a genuine error in the example
  tryCatch(validate_types(x), error = paste)

  ## to allow other types, e.g. gender to be integer, character or factor
  validate_types(x, tags_types(gender = c("integer", "character", "factor")))
}
}
\seealso{
\itemize{
\item \code{\link[=tags_types]{tags_types()}} to change allowed types
\item \code{\link[=validate_tags]{validate_tags()}} to perform a series of checks on the tags
\item \code{\link[=validate_linelist]{validate_linelist()}} to combine \code{validate_tags} and \code{validate_types}
}
}
