% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{sanity_check}
\alias{sanity_check}
\title{check x with various characters}
\usage{
sanity_check(x, NULL_allowed = FALSE, Class = NULL, min_oberserv = NULL,
  exact_in_match = NULL, fuzzy_match = NULL, exact_length = NULL,
  complete_cases = NULL, STOP = 1, message_provided = "")
}
\arguments{
\item{x}{an object to be checked.,}

\item{NULL_allowed}{whether a x == NULL is allowed,}

\item{Class}{the correct class of x}

\item{min_oberserv}{the min number of row / length that x should have,}

\item{exact_in_match}{each element of x shall be found in the exact_in_match vector
if exact_in_match is a data.frame, we will get the colnames of it as exact_in_match}

\item{fuzzy_match}{TEST feature}

\item{exact_length}{can let you test the exact length of a vector, OR exact number of colnames}

\item{complete_cases}{TRUE or NULL # check whether a dataframe have NA values}

\item{STOP}{whether to stop if there is an error.}

\item{message_provided}{replace the default error message}
}
\value{
return nothing if x passes checks, otherwise an error message
}
\description{
a single function that can do several different types of sanity checks at the same time
}
\details{
See sample code
}
\examples{

###_____ unit test ____


data = ggplot2::diamonds
# sanity_check(dasfdfdsfsgre)
null_checl = NULL ;
tryCatch( sanity_check(null_checl),
          error = function(err) print(err))
tryCatch( sanity_check(null_checl,NULL_allowed = TRUE),
          error = function(err) print(err))


tryCatch( sanity_check(c('x','y'),min_oberserv = 3),
          error = function(err) print(err))
tryCatch( sanity_check(c('x','y'),min_oberserv = 2),
          error = function(err) print(err))

tryCatch( sanity_check(data,Class = 'data.frame2'),
          error = function(err) print(err))
tryCatch( sanity_check(data,min_oberserv = 3000000),
          error = function(err) print(err))

tryCatch( sanity_check(data,exact_length = ncol(data) ),
          error = function(err) print(err))
tryCatch( sanity_check(
  data.frame(data,NA,stringsAsFactors = FALSE)[1:10,],
                       complete_cases = TRUE ),
          error = function(err) print(err))


colnames(data)
tryCatch( sanity_check(x= c('carat') ,exact_in_match = data),
          error = function(err) print(err))
tryCatch( sanity_check(x= c('carat') ,exact_in_match = colnames(data)) ,
          error = function(err) print(err))
tryCatch( sanity_check(x= c('carat2') ,exact_in_match = data),
          error = function(err) print(err))
tryCatch(  sanity_check(x= c('carat','carat2') ,exact_in_match = data),
           error = function(err) print(err))

tryCatch(  sanity_check(x=colnames(data),exact_in_match = c('carat')),
           error = function(err) print(err))

tryCatch(   sanity_check(x=data,exact_in_match = c('carat2')),
            error = function(err) print(err))

}
\keyword{internal}

