% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{paste_formula}
\alias{paste_formula}
\title{paste a formula as string}
\usage{
paste_formula(Formula, exclude_y = FALSE, clean = FALSE)
}
\arguments{
\item{Formula}{a formula to be pasted.}

\item{exclude_y}{a boolean, whether to exclude y when paste. Default is FALSE.}

\item{clean}{a boolean, whether to clean dirty formula: for example -- price ~ cut + carat - cut
will be cleaned into price ~ carat. Default is FALSE.}
}
\value{
a pasted formula in string, with all spaces deleted.
}
\description{
paste a formula as string
}
\details{
a pasted formula in string, with all spaces deleted.
This function uses \code{\link{get_y}} and \code{\link{get_x}} behind the scene.
}
\examples{

paste_formula(price~carat +cut)
paste_formula(price~carat + cut)

paste_formula(price~carat +cut,exclude_y = TRUE)
paste_formula(Formula = price ~ cut + carat, clean = TRUE)

paste_formula(price~carat +cut - cut, clean = TRUE)

# irregular formulas: cross lines
paste_formula(price~carat +
                cut ~ dsad)

paste_formula(price~carat +
                cut ~ dsad,exclude_y = TRUE)

}

