% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{check_names_delete}
\alias{check_names_delete}
\title{check whether list names (tobechecked) is within specified sets ('checking')}
\usage{
check_names_delete(tobechecked, checking, STOP = TRUE,
  tobechecked_name = "tobechecked", checking_name = "checking",
  default_value = NULL, PRINT = TRUE)
}
\arguments{
\item{tobechecked}{a named list / character vector to be checked}

\item{checking}{a character vector, the names in `tobechecked` is supposed to show up here.}

\item{STOP}{STOP if there are names in `tobechecked` not showing up in `checking`.
If FALSE, then we will delete the names not showing up in `checking`.}

\item{tobechecked_name}{a character, name of 'tobechecked' for printing.}

\item{checking_name}{a character, name of 'checking' for printing.}

\item{default_value}{value to be returned if all names in tobechecked are not in 'checking'.}

\item{PRINT}{whether print diagnostic information.}
}
\value{
a 'purified' named list / character vector , with all names not showing up in `checking` deleted.
}
\description{
check whether list names (tobechecked) is within specified sets ('checking')
}
\examples{

tobechecked = list('cut' = 1, 'dwewsdfds' = 2); checking = 'cut'

result =   check_names_delete(tobechecked, checking, STOP = FALSE,
                              tobechecked_name = 'focus_var',
                              checking_name = 'all_raw_vars')
result

result = check_names_delete(tobechecked, checking, STOP = FALSE)
result

tobechecked = c('cut', 'dsfsf'); checking = 'cut'
result = check_names_delete(tobechecked, checking, STOP = FALSE)
result

}
\keyword{internal}

