% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{model_support}
\alias{model_support}
\alias{predict_model}
\alias{model_type}
\title{Methods for extending limes model support}
\usage{
predict_model(x, newdata, type, ...)

model_type(x, ...)
}
\arguments{
\item{x}{A model object}

\item{newdata}{The new observations to predict}

\item{type}{Either \code{'raw'} to indicate predicted values, or \code{'prob'} to
indicate class probabilities}

\item{...}{passed on to \code{predict} method}
}
\value{
A data.frame in the case of \code{predict_model()}. If \code{type = 'raw'} it
will contain one column named \code{'Response'} holding the predicted values. If
\code{type = 'prob'} it will contain a column for each of the possible classes
named after the class, each column holding the probability score for class
membership. For \code{model_type()} a character string. Either \code{'regression'} or
\code{'classification'} is currently supported.
}
\description{
In order to have \code{lime} support for your model of choice \code{lime} needs to be
able to get predictions from the model in a standardised way, and it needs to
be able to know whether it is a classification or regression model. For the
former it calls the \code{predict_model()} generic which the user is free to
supply methods for without overriding the standard \code{predict()} method. For
the latter the model must respond to the \code{model_type()} generic.
}
\section{Supported Models}{

Out of the box, \code{lime} supports the following model objects:
\itemize{
\item \code{train} from caret
\item \code{WrappedModel} from mlr
\item \code{xgb.Booster} from xgboost
\item \code{H2OModel} from h2o
\item \code{keras.engine.training.Model} from keras
\item \code{lda} from MASS (used for low-dependency examples)
}

If your model is not one of the above you'll need to implement support
yourself. If the model has a predict interface mimicking that of
\code{predict.train()} from \code{caret}, it will be enough to wrap your model in
\code{\link[=as_classifier]{as_classifier()}}/\code{\link[=as_regressor]{as_regressor()}} to gain support. Otherwise you'll need
need to implement a \code{predict_model()} method and potentially a \code{model_type()}
method (if the latter is omitted the model should be wrapped in
\code{\link[=as_classifier]{as_classifier()}}/\code{\link[=as_regressor]{as_regressor()}}, everytime it is used in \code{\link[=lime]{lime()}}).
}

\examples{
# Example of adding support for lda models (already available in lime)
predict_model.lda <- function(x, newdata, type, ...) {
  res <- predict(x, newdata = newdata, ...)
  switch(
    type,
    raw = data.frame(Response = res$class, stringsAsFactors = FALSE),
    prob = as.data.frame(res$posterior, check.names = FALSE)
  )
}

model_type.lda <- function(x, ...) 'classification'

}
