% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_plot.R
\name{plot.lyl_ci}
\alias{plot.lyl_ci}
\title{Plot evolution of bootstrapped parameters for Life Years Lost}
\usage{
\method{plot}{lyl_ci}(x, level = 0.95, weights, ...)
}
\arguments{
\item{x}{An object of class \code{lyl_ci} (obtained with function \code{lyl_ci}).}

\item{level}{Confidence level (default is 0.95 for 95\% confidence intervals)}

\item{weights}{Vector with age distribution of disease/condition onset to be used when Life Years Lost are estimated
over a range of ages (with \code{lyl_range} function).}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
A plot with the evolution of bootstrapped parameters.
}
\description{
\code{plot} for objects of class \code{lyl_ci} creates a figure of the bootstrapped Life Years Lost
to examine if the number of iterations is enough.
}
\examples{

# Load simulated data as example
data(simu_data)

# Estimate remaining life expectancy and Life Years
# Lost after age 45 years and before age 95 years
lyl_estimation <- lyl(data = simu_data, t = age_death, status = death,
                      age_specific = 45, tau = 95)

\donttest{
# Calculate bootstrapped confidence interval (10 iterations to test)
lyl_estimation_ci <- lyl_ci(lyl_estimation, niter = 10)
plot(lyl_estimation_ci)

# Estimate remaining life expectancy and Life Years
# Lost after each age from 0 to 94 years and before age 95 years
lyl_estimation2 <- lyl_range(data = simu_data, t = age_death, status = death,
                             age_begin = 0, age_end = 94, tau = 95)

# Calculate bootstrapped confidence interval
lyl_estimation_ci2 <- lyl_ci(lyl_estimation2)
plot(lyl_estimation_ci2, weights = simu_data$age_disease)
}
}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_ci}} to estimate bootstrapped confidence intervals.}
 }
}
