% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_ttest.R
\name{L_ttest}
\alias{L_ttest}
\title{Likelihood Supports for the One Sample and Related Samples t Test}
\usage{
L_ttest(data1, data2, null=0, d=0.5, alt.2=NULL,
L.int=2, toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)
}
\arguments{
\item{data1}{a (non-empty) numeric vector of data values.}

\item{data2}{a (non-empty) numeric vector of data values for related sample, default = NULL.}

\item{null}{value for the null hypothesis, default = 0.}

\item{d}{Cohen's effect size, default = 0.5.}

\item{alt.2}{value for an alternative hypothesis, in units used for data, default = NULL.}

\item{L.int}{likelihood interval given for a given support value, e.g. 2 or 3, default = 2.}

\item{toler}{the desired accuracy using optimise, default = 0.0001.}

\item{logplot}{plot vertical axis as log likelihood, default = FALSE}

\item{supplot}{set minimum likelihood display value in plot, default = -10}

\item{verb}{show output, default = TRUE.}
}
\value{
$obs.mean - the observed mean or difference in mean for related samples.

$df - degrees of freedom.

$alt.H1 - mean value according to specified d.

$alt.H2 - specified second hypothesis value.

$S_max - maximum support for observed mean against the null.

$S_10 - support for d versus null.

$S_12 - support for d versus specified second hypothesis.

$S_20 - support for second hypothesis versus the null.

$like.int - likelihood interval.

$L.int.spec - specified likelihood interval in units of support.

$null.value - null value.

$t.val - t value for test against null.

$p.val - p value for test against null.

$d.obs - observed effect size.
}
\description{
This function calculates several different supports. Effect size (Cohen's d) and a
second alternative hypothesis value can be specified. The maximum support is the support
for the observed mean versus the null value. The support for the specified d versus
the null is also calculated. If a second hypothesis value is specified (in units of
the original measurements) then two further supports are calculated: d versus 2nd
alternative hypothesis, and 2nd alternative hypothesis versus the null.
The likelihood curve graphic with MLE and specified hypothesis values is produced.
The requested likelihood interval is provided and displayed on likelihood curve.
The t and p values for the test against the null value are given.
}
\examples{
# one sample Gosset's original additional hours of sleep data, p 29
mysample <- c(0.7, -1.6, -0.2, -1.2, -0.1, 3.4, 3.7, 0.8, 0.0, 2.0)
L_ttest(mysample, d=.5, alt.2=2, L.int=2)

# related samples, p 56
mysample2 <- c(1.9, 0.8, 1.1, 0.1, -0.1, 4.4, 5.5, 1.6, 4.6, 3.4)
L_ttest(mysample, mysample2, d=1, alt.2=2, L.int=2,
toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)
}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Baguley, T. (2012) Serious Stats, Palgrave Macmillan, ISBN: 978-0230577183

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430

Royall, R. M. (2000). On the probability of observing misleading statistical evidence.
Journal of the American Statistical Association, 95, 760.
}
\keyword{Likelihood;}
\keyword{interval}
\keyword{likelihood}
\keyword{support;}
\keyword{t}
\keyword{test;}
