\name{evaluate.from.interim.peaks} 
\alias{evaluate.from.interim.peaks} 
\title{likeLTD::evaluate.from.interim.peaks} 
\usage{evaluate.from.interim.peaks(file)}
\arguments{
  \item{file}{Restricted to only accept a filepath including the name "interim.RData", which is generated by evaluate.peaks() only if interim=TRUE. "interim.RData" will also be subsequently generated by evaluate.from.interim.peaks() thereafter, at regular intervals during the evaluation}
}
\value{
A list containing seven elements:
\item{Pros}{Prosecution results, structured as results from DEoptim::DEoptim.}
\item{Def}{Defence results, structured as results from DEoptim::DEoptim.}
\item{WoE}{WoE for each chunk. The final value is the final WoE.}
\item{Lp}{-log_{10} prosecution likelihood at each step usually.}
\item{Ld}{-log_{10} defence likelihood at each step usually.}
\item{seed.used}{Seed that is set at the beginning of computation; this will no longer apply if evaluate.from.interim.peaks is used.}
\item{seed.input}{Seed that is input by the user; this will no longer apply if evaluate.from.interim.peaks is used.}
} 
\description{
Optimize both prosecution and defence likelihoods, returning the weight of evidence.
}
\details{
  Optimize over parameter space, using a geometric progression of crossover rate and tolerance.
Both prosecution and defence cases are optimized simultaneously.
}
\seealso{evaluate}

