% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{maxima_selection}
\alias{maxima_selection}
\title{Image maxima selection based on values and neighborhood of local maxima}
\usage{
maxima_selection(maxi, dem_nl, hmin = 0, dmin = 0, dprop = 0)
}
\arguments{
\item{maxi}{cimg object or RasterLayer object. image with local maxima 
(typically output from \code{\link{maxima_detection}}, image values correspond 
to neighborhood radius on which pixels are global maxima in the initial image)}

\item{dem_nl}{cimg object. initial image from which maxima were detected}

\item{hmin}{numeric. minimum value in initial image for a maximum to be selected}

\item{dmin}{numeric. intercept term for selection of maxima depending on 
neighborhood radius: \code{maxi >= dmin + dem_nl * dprop}}

\item{dprop}{numeric. proportional term for selection of maxima depending on 
neighborhood radius: \code{maxi >= dmin + dem_nl * dprop}}
}
\value{
A cimg object or rasterLayer object which values are the radius (n) 
in meter of the square window (width 2n+1) where the center pixel is global 
maximum and which fulfill the selection criteria
}
\description{
In a maxima image (output of \code{\link{maxima_detection}}), sets values to 
zero for pixels which
\enumerate{
\item value in the initial image (from which maxima were detected) are below 
a threshold
\item values in the maxima image (corresponding to the radius of the 
neighborhood where they are global maxima) are below a threshold depending on 
the initial image value.
}
}
\examples{
data(chm_chablais3)

# maxima detection
maxi <- maxima_detection(chm_chablais3)

# several maxima selection settings
selected_maxi_hmin <- maxima_selection(maxi, chm_chablais3, hmin = 15)
selected_maxi_dm <- maxima_selection(maxi, chm_chablais3, dm = 2.5)
selected_maxi <- maxima_selection(maxi, chm_chablais3, dm = 1, dprop = 0.1)

# corresponding count number of remaining maxima
table(raster::values(maxi))
table(raster::values(selected_maxi_hmin))
table(raster::values(selected_maxi_dm))
table(raster::values(selected_maxi))

# plot original image
raster::plot(chm_chablais3, main = "Initial image")

# plot maxima images, original and first case
raster::plot(maxi, main = "Local maxima")
raster::plot(selected_maxi, main = "Selected maxima")
}
\seealso{
\code{\link{maxima_detection}}
}
