% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{terrain_points_metrics}
\alias{terrain_points_metrics}
\title{Computation of terrain metrics}
\usage{
terrain_points_metrics(p, centre = NULL, r = NULL)
}
\arguments{
\item{p}{matrix, data.frame or \code{\link[lidR]{LAS}} object with ground point 
coordinates (X, Y, Z). In case of an object which is not LAS, the object is first 
converted, which issues a warning}

\item{centre}{vector. x y coordinates of center to extract points inside a disc}

\item{r}{numeric. radius of disc}
}
\value{
a data.frame with altitude, exposition (gr), slope (gr) and adjR2 of 
plane fitting
}
\description{
This function computes topographic variables from a point cloud
\itemize{
\item{exposition}
\item{altitude}
\item{slope}
}
values are computed after fitting a plane to the points. It supposes a 
homogeneous sampling of the plot by points. Points can be cropped on disk if 
center and radius are provided. In case a centre is provided, the altitude 
is computed by bilinear interpolation at the center location 
(\code{\link[lidR]{grid_metrics}} with \code{\link[lidR]{tin}} algorithm), 
otherwise it is the mean of the points altitude range.
}
\examples{
# sample points
XYZ <- data.frame(x = runif(200, -10, 10), y = runif(200, -10, 10))
XYZ$z <- 350 + 0.3 * XYZ$x + 0.1 * XYZ$y + rnorm(200, mean = 0, sd = 0.5)
# compute terrain statistics
terrain_points_metrics(XYZ)
terrain_points_metrics(XYZ, centre = c(5, 5), r = 5)
# with a LAS object
data(las_chablais3)
terrain_points <- lidR::filter_ground(las_chablais3)
terrain_points_metrics(terrain_points)
terrain_points_metrics(terrain_points, centre = c(974360, 6581650), r = 10)
}
