% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.detection.R
\name{edgeDetection}
\alias{edgeDetection}
\title{Edge detection in gap image}
\usage{
edgeDetection(gaps, inside = TRUE)
}
\arguments{
\item{gaps}{raster object. gaps image where 1 represents gaps and 0 non-gaps areas}

\item{inside}{boolean. defines where the edge is extracted: either inside the gaps (an erosion is applied to the gaps image) or outside (a dilation is applied)}
}
\value{
A raster object where edges are labelled as 1.
}
\description{
Performs edge detection on a gap image (e.g. output from function \code{\link{gapDetection}}). The gap image is compared to a gap image which has undergone a dilation or erosion to identify edges of gaps.
}
\examples{
data(chmchablais3)

# fill NA values in canopy height model
chmchablais3[is.na(chmchablais3)] <- 0

# gap detection with distance larger than canopy height / 2
gaps <- gapDetection(chmchablais3, ratio=2, gap.max.height=1, min.gap.surface=10,
gapReconstruct=TRUE)

# edge detection
edges.inside <- edgeDetection(!is.na(gaps$gap.id))
edges.outside <- edgeDetection(!is.na(gaps$gap.id), inside=FALSE)

# edge propotion
sum(raster::values(edges.inside))/(nrow(edges.inside)*ncol(edges.inside))
sum(raster::values(edges.outside))/(nrow(edges.outside)*ncol(edges.outside))

# plot original image
raster::plot(chmchablais3, main="Initial image")

# plot binary image of gaps
raster::plot(gaps$gap.id>0, main="Gaps", legend=FALSE)

# plot edges
raster::plot(edges.inside, main="Edges (inside)", legend=FALSE)
raster::plot(edges.outside, main="Edges (outside)", legend=FALSE)

}
\seealso{
\code{\link{gapDetection}}
}
