% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_info.R
\name{retrieve_pulses}
\alias{retrieve_pulses}
\alias{retrieve_flightlines}
\alias{retrieve_scanlines}
\title{Retrieve individual pulses, flightlines or scanlines}
\usage{
retrieve_pulses(las)

retrieve_flightlines(las, dt = 30)

retrieve_scanlines(las)
}
\arguments{
\item{las}{A LAS object}

\item{dt}{numeric. The threshold time-lag used to retrieve flightlines}
}
\value{
An object of class \code{LAS}
}
\description{
Retrieve each individual pulse, individual flightline or individual scanline and assigns a number
to each point. The LAS object must be properly populated according to LAS specifications otherwise
users could find unexpected outputs.
}
\details{
\describe{
\item{\code{retrieve_pulses}}{Retrieves each individual pulse. It uses GPS time. An attribute
\code{pulseID} is added in the \code{LAS} object}
\item{\code{retrieve_scanlines}}{Retrieves each individual scanline. When data are sampled according to a
saw-tooth pattern (oscillating mirror), a scanline is one line, or row of data. The function relies
on the GPS field time to order the data. Then, the \code{ScanDirectionFlag} attribute is used to
retrieve each scanline. An attribute \code{scanlineID} is added in the \code{LAS} object}
\item{\code{retrieve_flightlines}}{Retrieves each individual flightline. It uses GPS time. In a
continuous dataset, once points are ordered by GPS time, the time between two consecutive points
does not exceed a few milliseconds. If the time between two consecutive points is too long it means
that the second point is from a different flightline. The default threshold is 30 seconds.
An attribute \code{flightlineID} is added in the \code{LAS} object.}
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

las <- retrieve_pulses(las)
las

las <- retrieve_flightlines(las)
plot(las, color = "flightlineID")
}
