% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_delete}
\alias{lib_delete}
\title{Delete a Data Library}
\usage{
lib_delete(x)
}
\arguments{
\item{x}{The data library to delete.}
}
\description{
The \code{lib_delete} function deletes a data library from
the file system and from memory.  All data files associated with the library
and the specified engine will be deleted.
If other files exist in the library directory, they will not be affected
by the delete operation.  

The directory that contains the data will also
not be affected by the delete operation.  To delete the data directory, 
use the \code{\link[base]{unlink}} function or other packaged functions.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add data to library
lib_add(dat, mtcars)
lib_add(dat, iris)

# Load library
lib_load(dat)

# Examine workspace
ls()
# [1] "dat" "dat.iris" "dat.mtcars" "tmp"

# Examine library
dat
# library 'dat': 2 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#     Name Extension Rows Cols   Size        LastModified
# 1 mtcars       rds   32   11 7.5 Kb 2020-11-05 21:18:17
# 2   iris       rds  150    5 7.5 Kb 2020-11-05 21:18:17

# Delete library
lib_delete(dat)

#' # Examine workspace again
ls()
# [1] "tmp"
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
