% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{alloc_compressor}
\alias{alloc_compressor}
\title{Allocate a libdeflate compressor}
\usage{
alloc_compressor(level = 6L)
}
\arguments{
\item{level}{Default `6L`. Integer in [0, 12] giving the compression level (0 = no compression, 1 = fastest, 6 = default, 12 = slowest).}
}
\value{
An external pointer (`externalptr`) to a libdeflate compressor.
}
\description{
Create a new libdeflate compressor at the specified compression level.
}
\seealso{
[base::memDecompress()] also provides DEFLATE compression via libdeflate, but it fixes the compression level at 6.
# allocate a compressor and compress a simple string
cmp = alloc_compressor()
raw_in = charToRaw("Example data")
raw_cmp = deflate_compress(cmp, raw_in)
stopifnot(is.raw(raw_cmp))
}
