% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldcat-api.R
\name{worldcat_api_locations_by}
\alias{worldcat_api_locations_by}
\alias{worldcat_api_locations_by_oclc}
\alias{worldcat_api_locations_by_isbn}
\alias{worldcat_api_locations_by_issn}
\title{Get holding libraries by standard number}
\usage{
worldcat_api_locations_by_oclc(
  x,
  location = "10032",
  include.bib.info = TRUE,
  max_libraries = Inf,
  servicelevel = "full",
  frbrGrouping = "on",
  libtype = NULL,
  wskey = getOption("libbib.wskey", ""),
  print.progress = TRUE,
  debug = FALSE
)

worldcat_api_locations_by_isbn(
  x,
  location = "10032",
  include.bib.info = TRUE,
  max_libraries = Inf,
  servicelevel = "full",
  frbrGrouping = "on",
  libtype = NULL,
  wskey = getOption("libbib.wskey", ""),
  print.progress = TRUE,
  debug = FALSE
)

worldcat_api_locations_by_issn(
  x,
  location = "10032",
  include.bib.info = TRUE,
  max_libraries = Inf,
  servicelevel = "full",
  frbrGrouping = "on",
  libtype = NULL,
  wskey = getOption("libbib.wskey", ""),
  print.progress = TRUE,
  debug = FALSE
)
}
\arguments{
\item{x}{The standard number to search using. Must be a string.}

\item{location}{The holding institutions are sorted roughly by geographic
proximity to this zip-code, country code, etc...
If \code{max_libraries} is \code{Inf} (the default), the
starting location doesn't matter since all holding
institutions are returned. Defaults to the zip code
of Washington Heights, NYC.}

\item{include.bib.info}{A logical indicating whether to include
bibliographic metadata associated with the
work (provided by
\code{worldcat_api_bib_read_info_by_...}).
This is very useful for error checking so
default is \code{TRUE}.}

\item{max_libraries}{The maximum number of libraries to return.
Must be a number between 0 and 100 or \code{Inf}.
If \code{Inf} (default), the function will
automatically make all follow-up requests to retrieve
all holding institutions. Beware that each page of
100 institutions counts as one API request. If the
bib searched for is popular, set this to non-\code{Inf}.}

\item{servicelevel}{Either "full" (the default) or "default". If "full",
the number of holding libraries returned is the same
as if a user logged in to an institution when making
a WorldCat search. If "default", the results are
a subset of WorldCat libraries, namely those that
participate in worldcat.org. In this way, the number
of holding libraries is tantamount to if a non-logged-in
user searched WorldCat. The number of results with "full"
is always at least as high as with "default", so the
default is "full". If this package is being used in
an application where a user is not logged in to an
institution, set this to "default". It is up to you
to respect the WorldCat API's conditions.}

\item{frbrGrouping}{With this parameter set to "on" (default),
an attempt is made by the WorldCat API to group
together similar editions and present only the top
held record as the representative record for that group.
If not, only institutions holding the exact standard
number specified will be returned.}

\item{libtype}{One of \code{NULL} (default), "academic", "public",
"government", or "other". \code{NULL} will return all
library subsets. The others will only search for holdings
from insitutions of that library type.}

\item{wskey}{A WorldCat API key (default is \code{getOption("libbib.wskey")})}

\item{print.progress}{A logical indicating whether a message should be
displayed for each API request. If \code{max_libraries}
is \code{TRUE} a message will be displayed for every
group of 100 institutions the function fetches.
(default is \code{TRUE})}

\item{debug}{A logical indicating whether the HTTP and API
responses should be printed (for debugging)
(default is \code{FALSE})}
}
\value{
A \code{data.table} with each row corresponding to a holding library.
}
\description{
Access the results of a WorldCat location API search by ISBN, ISSN,
or OCLC number. Returns a \code{data.table} with rows corresponding to
each holding institution. The columns contain the standard number
provided, the institution identifier, the institution name, number
of copies held by that insitution, and, by default, the bibliographic
information provided by \code{worldcat_api_bib_read_info_by_...}.
This information is helpful to ensure thaat the standard number
provided successfully resolved to a single OCLC work.
}
\details{
Numerous parameters are provided that change the API url
parameters. See parameter section for details on each.


If something went wrong, most columns (especially the bibliographic
info columns) will be NA. You should always check the output.

As with all API access functions in this package, it's up to the
user to limit their API usage so as to not get blocked. These
functions are deliberately not vectorized for this reason; they
only accept one standard number at a time.

This (and other) WorldCat API communication functions require a
WorldCat API key. The easiest way to use these functions is to
set a global options with your key:
\code{options("libbib.wskey"="YOUR KEY HERE")}

Final note: all of these API functions seem to work better with
OCLC numbers than any other standard number. If multiple standard
numbers are available, using the OCLC number is always preferred.
In this function, for example, searching for ISSN: 14664410
(Journal of Architecture) will (at time of writing) return only one
insitution, whereas searching by it's OCLC number (958283020) will
yield many more (660, at time of writing, with default parameters).
}
\examples{

\dontrun{
# worldcat_api_locations_by_oclc("877749545", max_libraries=10,
#                                include.bib.info=FALSE)
#         oclc institution_identifier
#       <char>                 <char>
# 1: 877749545                    NLE
# 2: 877749545                    NLW
# 3: 877749545                    EUM
# 4: 877749545                    LTU
# 5: 877749545                    ELU
# 6: 877749545                  UKUAL
#                                 institution_name copies
#                                           <char> <char>
# 1:                  National Library of Scotland      1
# 2:                     National Library of Wales      1
# 3:              University of Manchester Library      1
# 4: University of Leicester, David Wilson Library      1
# 5:     University of London Senate House Library      1
# 6:                 University of the Arts London      1

}

}
