% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_clean_names}
\alias{get_clean_names}
\title{Takes a data.frame and returns cleaned column names}
\usage{
get_clean_names(dat)
}
\arguments{
\item{dat}{A data.frame}
}
\value{
Returns a vector of cleaned names
}
\description{
This function takes a data.frame, extracts the column names,
and returns a vector of those column names but cleaned and
stripped of potentially troublesome names
}
\details{
All space/whitespace characters are replaced with underscores,
as are all characters not from A-Z, a-z, an underscore, or a digit
}
\examples{
ejemplo <- iris
names(ejemplo) <- c("Sepal Length", "Sepal@Width", "Petal	Length",
                    "Petal\\\\nWidth", "Spêcies")
# c("Sepal_Length" "Sepal_Width"  "PetalLength"  "Petal_nWidth" "Sp_cies")

}
