% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the-web.R
\name{worldcat_permalink_from_isbn}
\alias{worldcat_permalink_from_isbn}
\title{Get WorldCat catalog permalinks from ISBNs}
\usage{
worldcat_permalink_from_isbn(x, normalize = TRUE)
}
\arguments{
\item{x}{A string (or vector of strings) of ISBNs}

\item{normalize}{a logical indicating whether the ISBNs should be
normalized prior to creating the permalink
(default = TRUE)}
}
\value{
Worldcat permalinks using ISBNs.
}
\description{
Takes a string representation of ISBNs. Returns permalinks
to the WorldCat catalog entries using those ISBNs.
}
\details{
If normalize=TRUE and the ISBN is invalid, the permalink is NA.
If normalize=FALSE, the permalink may be invalid. No validity
check on the URL is performed
}
\examples{

worldcat_permalink_from_isbn("1788393724")
# http://www.worldcat.org/isbn/1788393724

worldcat_permalink_from_isbn("0-124-91540-X")
# http://www.worldcat.org/isbn/012491540X

worldcat_permalink_from_isbn("0-124-91540-X", normalize=FALSE)
# http://www.worldcat.org/isbn/0-124-91540-X

# vectorized
worldcat_permalink_from_isbn(c("1788393724", NA, "0-124-91540-X"))

}
