% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{get_issn_check_digit}
\alias{get_issn_check_digit}
\title{Get ISSN check digit}
\usage{
get_issn_check_digit(x, allow.hyphens = FALSE, errors.as.nas = FALSE)
}
\arguments{
\item{x}{A string of 7 or 8 digits}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{errors.as.nas}{return NA if error instead of throwing error}
}
\value{
Returns the character check digit that satifies the
        mod 11 condition. Returns "X" if 10. Returns NA if input is NA
}
\description{
Takes a string representation of an ISSN
and returns the check digit that satisfies the necessary condition.
It can take a 8 digit string (and ignore the already extant check digit)
or a 7 digit string (without the last digit)
}
\examples{

get_issn_check_digit("03785955")

get_issn_check_digit("2434-561X", allow.hyphens=TRUE)

# nine digit string
get_issn_check_digit("0378595")

# vectorized
get_issn_check_digit(c("0378595", "2434561X", NA))

}
