% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{get_isbn_13_check_digit}
\alias{get_isbn_13_check_digit}
\title{Get ISBN 13 check digit}
\usage{
get_isbn_13_check_digit(x, allow.hyphens = FALSE, errors.as.nas = FALSE)
}
\arguments{
\item{x}{A string of 12 or 13 digits}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{errors.as.nas}{return NA if error instead of throwing error}
}
\value{
Returns the character check digit that satifies the
        mod 10 condition. Returns NA if input is NA
}
\description{
Takes a string representation of an ISBN 13
and returns the check digit that satisfies the necessary condition.
It can take a 13 digit string (and ignore the already extant check digit)
or a 12 digit string (without the last digit)
}
\examples{

get_isbn_13_check_digit("9780306406157")

# 12 digit string
get_isbn_13_check_digit("978030640615")

get_isbn_13_check_digit("onetwothreefo", errors.as.nas=TRUE)  # NA

# vectorized
get_isbn_13_check_digit(c("9780306406157", "9783161484100"))

}
