% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{weibull_dispersion_function}
\alias{weibull_dispersion_function}
\title{Estimate Weibull Dispersion for Accelerated Failure Time Model}
\usage{
weibull_dispersion_function(
  mu,
  y,
  order_indices,
  family,
  observation_weights,
  status
)
}
\arguments{
\item{mu}{Predicted survival times}

\item{y}{Observed response/survival times}

\item{order_indices}{Indices to align status with response}

\item{family}{Weibull AFT model family specification}

\item{observation_weights}{Optional observation weights}

\item{status}{Censoring indicator (1 = event, 0 = censored)
Indicates whether an event of interest occurred (1) or the observation was
right-censored (0). In survival analysis, right-censoring occurs when the
full survival time is unknown, typically because the study ended or the
subject was lost to follow-up before the event of interest occurred.}
}
\value{
Squared scale estimate for the Weibull AFT model (dispersion)
}
\description{
Computes the scale parameter for a Weibull accelerated failure time (AFT)
model, supporting right-censored survival data.

This both provides a tool for actually fitting Weibull AFT Models, and
boilerplate code for users who wish to incorporate Lagrangian multiplier
smoothing splines into their own custom models.
}
\examples{

## Simulate survival data with covariates
set.seed(1234)
n <- 1000
t1 <- rnorm(n)
t2 <- rbinom(n, 1, 0.5)

## Generate survival times with Weibull-like structure
lambda <- exp(0.5 * t1 + 0.3 * t2)
yraw <- rexp(n, rate = 1/lambda)

## Introduce right-censoring
status <- rbinom(n, 1, 0.75)
y <- ifelse(status, yraw, runif(1, 0, yraw))

## Example of using dispersion function
mu <- mean(y)
order_indices <- seq_along(y)
weights <- rep(1, n)

## Estimate dispersion
dispersion_est <- weibull_dispersion_function(
  mu = mu,
  y = y,
  order_indices = order_indices,
  family = weibull_family(),
  observation_weights = weights,
  status = status
)

print(dispersion_est)

}
\seealso{
\code{\link{weibull_scale}} for the underlying scale estimation function
}
