% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{make_constraint_matrix}
\alias{make_constraint_matrix}
\title{Create Smoothing Spline Constraint Matrix}
\usage{
make_constraint_matrix(
  nc,
  CKnots,
  power1_cols,
  power2_cols,
  nonspline_cols,
  interaction_single_cols,
  interaction_quad_cols,
  triplet_cols,
  K,
  include_constrain_fitted,
  include_constrain_first_deriv,
  include_constrain_second_deriv,
  include_constrain_interactions,
  include_2way_interactions,
  include_3way_interactions,
  include_quadratic_interactions,
  colnm_expansions,
  expansion_scales
)
}
\arguments{
\item{nc}{Integer; number of columns in basis expansion}

\item{CKnots}{Matrix; basis expansions evaluated at knot points}

\item{power1_cols}{Integer vector; indices of linear terms}

\item{power2_cols}{Integer vector; indices of quadratic terms}

\item{nonspline_cols}{Integer vector; indices of non-spline terms}

\item{interaction_single_cols}{Integer vector; indices of linear interaction terms}

\item{interaction_quad_cols}{Integer vector; indices of quadratic interaction terms}

\item{triplet_cols}{Integer vector; indices of three-way interaction terms}

\item{K}{Integer; number of interior knots (\eqn{K+1} partitions)}

\item{include_constrain_fitted}{Logical; constrain function values at knots}

\item{include_constrain_first_deriv}{Logical; constrain first derivatives at knots}

\item{include_constrain_second_deriv}{Logical; constrain second derivatives at knots}

\item{include_constrain_interactions}{Logical; constrain interaction terms at knots}

\item{include_2way_interactions}{Logical; include two-way interactions}

\item{include_3way_interactions}{Logical; include three-way interactions}

\item{include_quadratic_interactions}{Logical; include quadratic interactions}

\item{colnm_expansions}{Character vector; column names for basis expansions}

\item{expansion_scales}{Numeric vector; scaling factors for standardization}
}
\value{
Matrix \eqn{\textbf{A}} of constraint coefficients. Columns correspond to
constraints, rows to coefficients across all \eqn{K+1} partitions.
}
\description{
Constructs constraint matrix \eqn{\textbf{A}} enforcing continuity and smoothness at knot boundaries
by constraining function values, derivatives, and interactions between partitions.
}
\keyword{internal}
