% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_dG_dlambda}
\alias{compute_dG_dlambda}
\title{Compute Derivative of Penalty Matrix G with Respect to Lambda}
\usage{
compute_dG_dlambda(
  G,
  L,
  K,
  lambda,
  unique_penalty_per_partition,
  L_partition_list,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{G}{A list of penalty matrices \eqn{\textbf{G}} for each partition}

\item{L}{The base penalty matrix \eqn{\textbf{L}}}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{lambda}{Smoothing parameter value \eqn{\lambda}}

\item{unique_penalty_per_partition}{Logical indicating partition-specific penalties}

\item{L_partition_list}{Optional list of partition-specific penalty matrices \eqn{\textbf{L}_k}}

\item{parallel}{Logical to enable parallel processing}

\item{cl}{Cluster object for parallel computation}

\item{chunk_size}{Size of chunks for parallel processing}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remainder chunks}
}
\value{
A list of derivative matrices \eqn{d\textbf{G}/d\lambda} for each partition
}
\description{
Calculates the derivative of the penalty matrix \eqn{\textbf{G}} with respect to the
smoothing parameter lambda (\eqn{\lambda}), supporting both global and partition-specific penalties.
This is related to the derivative of the diagonal weight matrix \eqn{1/(1+\textbf{x}^{T}\textbf{U}\textbf{G}\textbf{x})} w.r.t. the penalty.
}
\keyword{internal}
