% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-logging.R
\name{with_log_level}
\alias{with_log_level}
\alias{with_log_value}
\title{Inject Values into Logging Calls}
\usage{
with_log_level(level, code, logger = lgr::lgr)

with_log_value(values, code, logger = lgr::lgr)
}
\arguments{
\item{level}{\code{integer} or \code{character} scalar: the desired log level}

\item{code}{Any \R code}

\item{logger}{a \link{Logger}. defaults to the root logger (lgr::lgr).}

\item{values}{a named \code{list} of values to be injected into the logging calls}
}
\value{
whatever \code{code} would return
}
\description{
\code{with_log_level} temporarily overrides the log level of all \link{LogEvents}
created by target \link{Logger}.
}
\details{
These functions abuses lgr's filter mechanic to modify LogEvents in-place
before they passed on the Appenders. Use with care as they can
produce hard to reason about code.
}
\examples{
with_log_level("warn", {
  lgr$info("More important than it seems")
  FATAL("Really not so bad")
})

with_log_value(
  list(msg = "overriden msg"),  {
  lgr$info("bar")
  INFO("FOO")
})
}
