% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-select.R
\name{select}
\alias{select}
\alias{select_freq}
\alias{select.integrate}
\alias{select_freq.integrate}
\title{Select relevant components}
\usage{
select(fit, reduce = function(x) base::mean(x), threshold = 0.95, ...)

select_freq(fit, threshold = 0.95, ...)

select.integrate(
  fit,
  reduce = function(x) base::mean(x),
  p = function(x) stats::dbeta(x, 100, 5),
  h = 0.01,
  verbose = TRUE,
  ...
)

select_freq.integrate(
  fit,
  p = function(x) stats::dbeta(x, 100, 5),
  h = 0.01,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{fit}{An object of class \code{lgpfit}.}

\item{reduce}{The \code{reduce} argument for \code{\link{relevances}}.}

\item{threshold}{Threshold for relevance sum.
Must be a value between 0 and 1.}

\item{...}{Additional arguments to \code{\link{relevances}}.}

\item{p}{A threshold density over interval [0,1].}

\item{h}{A discretization parameter for computing a quadrature.}

\item{verbose}{Should this show a progress bar?}
}
\value{
See description.
}
\description{
\itemize{
  \item \code{select} performs strict selection, returning either \code{TRUE}
  or \code{FALSE} for each component.
  \item \code{select.integrate} is like \code{select}, but instead of
  a fixed threshold, computes probabilistic selection by integrating over
  a threshold density.
  \item \code{select_freq} performs the selection separately using
  each parameter draw and returns the frequency at which each
  component was selected.
  \item \code{select_freq.integrate} is like \code{select_freq}, but
  instead of a fixed threshold, computes probabilistic selection
  frequencies by integrating over a threshold density.
}
}
