% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lgpsim.R
\name{plot_sim}
\alias{plot_sim}
\title{Visualize an lgpsim object (simulated data)}
\usage{
plot_sim(
  simdata,
  group_by = "id",
  x_name = "age",
  h_name = "h",
  y_name = "y",
  comp_idx = NULL,
  color_by = NA,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{simdata}{an object of class \linkS4class{lgpsim}}

\item{group_by}{grouping factor}

\item{x_name}{name of x-axis variable}

\item{h_name}{name of the signal in \code{simdata$components} ("h" or "f")}

\item{y_name}{name of response variable}

\item{comp_idx}{Possible index of a component to be shown.
If this is NULL, the data and total signal are shown.}

\item{color_by}{coloring factor}

\item{verbose}{should some information be printed?}

\item{...}{additional arguments to \code{\link{plot_api_g}} or
\code{\link{plot_api_c}}}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Visualize an lgpsim object (simulated data)
}
