% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lgcpMethods.R
\name{plot.lgcpQuantiles}
\alias{plot.lgcpQuantiles}
\title{plot.lgcpQuantiles function}
\usage{
\method{plot}{lgcpQuantiles}(x, sel = 1:dim(x)[3], ask = TRUE,
  crop = TRUE, plotwin = FALSE, ...)
}
\arguments{
\item{x}{an object of class lgcpQuantiles}

\item{sel}{vector of integers between 1 and grid$len: which grids to plot. Default NULL, in which case all grids are plotted.}

\item{ask}{logical; if TRUE the user is asked before each plot}

\item{crop}{whether or not to crop to bounding box of observation window}

\item{plotwin}{logical whether to plot the window attr(x,"window"), default is FALSE}

\item{...}{other arguments  passed to image.plot}
}
\value{
grid plotting
This is a wrapper function for image.lgcpgrid
}
\description{
Plots \code{lgcpQuantiles} objects: output from \code{quantiles.lgcpPredict}
}
\examples{
\dontrun{qtiles <- quantile(lg,qt=c(0.5,0.75,0.9),fun=exp)}
                          # assumed that lg has class lgcpPredict
\dontrun{plot(qtiles)}
}
\seealso{
\link{quantile.lgcpPredict}
}

