% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{lfmm_sampler}
\alias{lfmm_sampler}
\title{LFMM generative data sampler}
\usage{
lfmm_sampler(n, p, K, outlier.prop, cs, sigma = 0.2, B.sd = 1,
  B.mean = 0, U.sd = 1, V.sd = 1)
}
\arguments{
\item{n}{number of observations.}

\item{p}{number of response variables.}

\item{K}{number of latent variables (factors).}

\item{outlier.prop}{proportion of outlier.}

\item{cs}{correlation between X and U.}

\item{sigma}{standard deviation of residual errors.}

\item{B.sd}{standard deviation for the effect size (B).}

\item{B.mean}{mean of B.}

\item{U.sd}{standard deviations for K factors.}

\item{V.sd}{standard deviations for loadings.}
}
\value{
A list with simulated data.
}
\description{
Simulate data from the latent factor model.
}
\details{
\code{lfmm_sampler()} sample a response matrix Y and a primary variable X such that

Y = U t(V) + X t(B) + Epsilon.

U,V, B and Epsilon are simulated according to normal multivariate distributions.
Moreover U and X are such that \code{cor(U[,i], X) = cs[i]}.
}
\examples{

dat <- lfmm_sampler(n = 100, 
                    p = 1000, 
                    K = 3,
                    outlier.prop = 0.1,
                    cs = c(0.8),
                    sigma = 0.2,
                    B.sd = 1.0, 
                    B.mean = 0.0,
                    U.sd = 1.0, 
                    V.sd = 1.0)
}
\author{
kevin caye, olivier francois
}
