% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire.R
\name{fire}
\alias{fire}
\title{Evaluate rules and obtain truth-degrees}
\usage{
fire(
  x,
  rules,
  tnorm = c("goedel", "goguen", "lukasiewicz"),
  onlyAnte = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{x}{Truth degrees of predicates. \code{x} could be either a numeric
matrix or a numeric vector. If vector is given then each named element represents
a truth value of a predicate. If matrix is given then each row of the matrix
is evaluated sequentially as a vector. The values must be in the interval
\eqn{[0, 1]}.}

\item{rules}{Either an object of S3 class \code{\link[=farules]{farules()}} or a list of character
vectors where each vector is a rule in a conjunctive form. Elements of these
character vectors (i.e., predicate names) must correspond to
the \code{x}'s names (of elements resp. columns if \code{x} is a vector resp. matrix).}

\item{tnorm}{A character string representing a triangular norm to be used
(either \code{"goedel"}, \code{"goguen"}, or \code{"lukasiewicz"}) or an arbitrary function
that performs element-wise computation on arbitrary number of vector parameters
similarly as e.g. \code{\link[=pgoedel.tnorm]{pgoedel.tnorm()}}, \code{\link[=pgoguen.tnorm]{pgoguen.tnorm()}} or \code{\link[=plukas.tnorm]{plukas.tnorm()}}.}

\item{onlyAnte}{\code{TRUE} is useful if rules store both the antecedent and consequent
and if only the antecedent-part of a rule should be included into the evulated
conjunction. Antecedent-part of a rule are all predicates in the vector starting from
the 2nd position. \code{TRUE} value in this parameter causes the first element of each
rule to be ignored.

If \code{FALSE}, all predicates in a rule will be included in the conjunction.}

\item{parallel}{Deprecated parameter. Computation is done sequentially.}
}
\value{
If \code{x} is a matrix then the result of this function is a list
of numeric vectors with truth values of each rule, i.e., each element of the
resulting list corresponds to a rule and each value of the vector in the resulting
list corresponds to a row of the original data matrix \code{x}.

\code{x} as a vector is treated as a single-row matrix.
}
\description{
Given truth degrees of predicates, compute the truth value of given list of rules.
}
\details{
The aim of this function is to compute the truth value of each rule in a
\code{rules} list by assigning truth values to rule's predicates given by data \code{x}.

\code{x} is a numeric vector or numeric matrix of truth values of predicates. If
\code{x} is vector then \code{names(x)} must correspond to the predicate names
in \code{rules}. If \code{x} is a matrix then each column should represent a predicate
and thus \code{colnames(x)} must correspond to predicate names in \code{rules}.
Values of \code{x} are interpreted as truth values, i.e., they must be from the
interval \eqn{[0, 1]}. If matrix is given, the resulting truth values are
computed row-wisely.

\code{rules} may be a list of character vectors or an instance of the S3 class
\code{\link[=farules]{farules()}}. The character vectors in the \code{rules} list represent formulae
in conjunctive form. If \code{onlyAnte=FALSE}, \code{fire()} treats the rule as
a conjunction of all predicates, i.e., a conjunction of all predicates is
computed. If \code{onlyAnte=TRUE}, the first element of each rule is removed
prior evaluation, i.e., a conjunction of all predicates except the first
are computed: this is useful if \code{rules} is a \code{\link[=farules]{farules()}} object, since
\code{\link[=farules]{farules()}} objects save a rule's consequent as the first element (see also
\code{\link[=antecedents]{antecedents()}} and \code{\link[=consequents]{consequents()}} functions).

The type of  conjunction to be computed can be specified with the \code{tnorm} parameter.
}
\examples{

# fire whole rules on a vector
x <- 1:10 / 10
names(x) <- letters[1:10]
rules <- list(c('a', 'c', 'e'),
              c('b'),
              c('d', 'a'),
              c('c', 'a', 'b'))
fire(x, rules, tnorm='goguen', onlyAnte=FALSE)

# fire antecedents of the rules on a matrix
x <- matrix(1:20 / 20, nrow=2)
colnames(x) <- letters[1:10]
rules <- list(c('a', 'c', 'e'),
              c('b'),
              c('d', 'a'),
              c('c', 'a', 'b'))
fire(x, rules, tnorm='goedel', onlyAnte=TRUE)

# the former command should be equal to
fire(x, antecedents(rules), tnorm='goedel', onlyAnte=FALSE)

}
\seealso{
\code{\link[=aggregateConsequents]{aggregateConsequents()}}, \code{\link[=defuzz]{defuzz()}}, \code{\link[=perceive]{perceive()}}, \code{\link[=pbld]{pbld()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}, \code{\link[=farules]{farules()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{multivariate}
\keyword{robust}
