#' Emoticons
#'
#' A \pkg{data.table} key containing common emoticons (adapted from
#' Wikipedia's Page semi-protected 'List of emoticons').
#'
#' @details
#' \itemize{
#'   \item x. The graphic representation of the emoticon
#'   \item y. The meaning of the emoticon
#' }
#' 
#' @section License: https://creativecommons.org/licenses/by-sa/3.0/legalcode
#' @docType data
#' @keywords datasets
#' @name hash_emoticons
#' @usage data(hash_emoticons)
#' @format A data.table with 144 rows and 2 variables
#' @references https://en.wikipedia.org/wiki/List_of_emoticons
#' @examples
#' \dontrun{
#' library(data.table)
#' hash_emoticons[c(':-(', '0:)')]

#' }
NULL
