#' Irregular Nouns Word Dataframe
#' 
#' A dataset containing a \code{data.frame} of irregular noun singular and 
#' plural forms from Arizona Department of Education (https://cms.azed.gov)
#' and augmented with selected common nouns from Wikipedia's "English Plurals" 
#' (https://en.wikipedia.org/wiki/English_plurals).
#' 
#' @details 
#' \itemize{ 
#'   \item singular. The singular form of the noun
#'   \item plural. The plural form of the noun
#' } 
#' 
#' @section License: The Wikipedia data is Creative Commons.  See 
#' https://creativecommons.org/licenses/by-sa/3.0/ for License information.
#' @docType data 
#' @keywords datasets 
#' @name pos_df_irregular_nouns 
#' @usage data(pos_df_irregular_nouns) 
#' @format A data frame with 124 rows and 2 variables  
#' https://cms.azed.gov/home/GetDocumentFile?id=54de1d89aadebe14a8707103 \cr \cr
#' https://en.wikipedia.org/wiki/English_plurals
NULL 


