\name{theme}
\alias{theme}
\alias{set}

\title{Set the Default Color Theme and Other System Settings}

\description{
Deprecated Name: \code{set}

Each graph is based on a default color theme. The original default is \code{colors="dodgerblue"}, but \code{theme} allows other color palettes to be set as default as well. Setting \code{ghost=TRUE} provides transparency effects against a black background. Other system settings are also available.}

\usage{
theme(colors=c("blue", "gray", "rose", "green", "gold", "red",
         "dodgerblue", "purple", "sienna", "orange.black",
         "gray.black", "white"),

         color.fill.bar=NULL, trans.fill.bar=NULL,
         color.fill.pt=NULL, trans.fill.pt=NULL,
         color.stroke.bar=NULL, color.stroke.pt=NULL,
         color.fill.ellipse=NULL,
         color.bg=NULL, color.grid=NULL, color.box=NULL,
         color.heat=NULL, ghost=NULL,


         n.cat=getOption("n.cat"), lab.size=getOption("lab.size"),
         suggest=getOption("suggest"),
         quiet=getOption("quiet"), brief=getOption("brief"),

         results=getOption("results"), explain=getOption("explain"),
         interpret=getOption("interpret"), document=getOption("document"), 
         code=getOption("code"),

         width=120, show=FALSE)

set(\ldots)
}


\arguments{
  \item{colors}{The specified color scheme.}
  \item{color.fill.bar}{Color of a filled region, such as a histogram bar.}
  \item{trans.fill.bar}{The transparency of a filled bar or rectangular region,
       such as a histogram bar or the box in a box plot. Value from 0 to 1,
       opaque to transparent.}
  \item{color.fill.pt}{Color of a filled region, such as a plotted point.}
  \item{trans.fill.pt}{The transparency of the inner region of a plotted point.
       Value from 0 to 1, opaque to transparent.}
  \item{color.stroke.bar}{Color of the border of a filled region such as a histogram
       bar.}
  \item{color.stroke.pt}{Color of a line or outline of a filled region, such as the
       border of a plotted point.}
  \item{color.fill.ellipse}{Color of the fill for an ellipse in a scatter plot.}
  \item{color.bg}{Color of the plot background.}
  \item{color.grid}{Color of the grid lines.}
  \item{color.box}{Color of border around the plot background, the box, that encloses 
        the plot, with a default of \code{"black"}.}
  \item{color.heat}{Color of the heat map for correlation matrices.}
  \item{ghost}{If \code{TRUE}, add a black background, transparent grid lines
       and transparency for the bars. Overrides individual settings for
       those values. Setting to \code{FALSE} has no effect.}
  \item{n.cat}{Number of categories that specifies the largest number of unique
        equally-spaced values of variable of a numeric data type for which the
        variable will be analyzed as categorical. Applies to
        \code{\link{ScatterPlot}} and 
        \code{\link{SummaryStats}}, and also to the functions such as 
        \code{\link{Histogram}} when processing multiple graphs.}
  \item{lab.size}{Size of labels for x and y axes.}
  \item{suggest}{If \code{TRUE}, then provide suggestions for alternative analyses.}
  \item{quiet}{If \code{TRUE} then some functions suppress console output.}
  \item{brief}{If set to \code{TRUE}, reduced text output. Can change system default
       with \code{\link{theme}} function.}
  \item{results}{For the R markdown file generated by the knitr.file option, 
        show the results.}
  \item{explain}{For the R markdown file generated by the knitr.file option, 
        explain the results.}
  \item{interpret}{For the R markdown file generated by the knitr.file option, 
        interpret the results.}
  \item{document}{For the R markdown file generated by the knitr.file option,
        documents the code that generated the results.} 
  \item{code}{For the R markdown file generated by the knitr.file option, 
        shows the code that generated the results.}
  \item{width}{Maximum width of each line displayed at the console, just accesses
        the standard R options function for width.}
  \item{show}{Option for showing all settings.}
  \item{\dots}{Parameter values.}
}


\details{
Sets the default color palette via the R \code{\link{options}} statement, as well as the transparency of plotted bars and points. Each time \code{colors} is reset, the specific color options are reset to their default values, which includes a transparency fill for plotted points of 0.66.

The gray color scheme is based on the colors used in Hadley Wickham's \code{ggplot2} package.

Set \code{ghost=TRUE} is equivalent to setting \code{color.bg} to \code{"black"} and \code{color.grid} to \code{"transparent"} with a bar transparency of 0.7. It overrides these settings individually, so must turn \code{ghost=FALSE} and set each of the three settings individually to change from the standard \code{ghost} settings.}

\author{David W. Gerbing (Portland State University; \email{gerbing@pdx.edu})}

\references{
Wickham, Hadley, ggplot2: Elegant Graphics for Data Analysis, 2nd edition, Springer, 2009.
}

\seealso{
\code{\link{options}}.
}

\examples{
# set all subsequent graphic output to gray scale
theme(colors="gray")

# define a custom color theme: sienna
# this works regardless of the set color theme because
#   all of the individual components of the theme are changed
# the trans options are the default values, so not necessary to
#   set unless already changed previously
# the three ghost settings - trans.fill.bar, color.grid and color.bg --
#   must be manually entered to achieve  a ghost plot
theme(color.fill.bar="seagreen3")
theme(color.fill.pt="seagreen3")
theme(color.stroke.bar="seagreen4")
theme(color.stroke.pt="seagreen4")
theme(color.bg="seashell1")
theme(color.grid="seashell2")
theme(trans.fill.bar=.00)
theme(trans.fill.pt=.66)

# all numeric variables with 8 or less unique values and equally spaced
#  intervals are analyzed as categorical variables
theme(n.cat=8)}


% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ sets }
\keyword{ csv }


