% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.r
\name{grid_arrange_shared_legend}
\alias{grid_arrange_shared_legend}
\title{Share a legend between multiple plots}
\usage{
grid_arrange_shared_legend(
  ...,
  ncol = length(list(...)),
  nrow = 1,
  position = c("bottom", "right", "top", "left"),
  plot = TRUE
)
}
\arguments{
\item{...}{Objects to plot. First argument should be a ggplot2 object, 
as the legend is extracted from this.
Other arguments are passed on to 
\code{\link[gridExtra]{arrangeGrob}}, 
including named arguments that are not defined for \code{grid_arrange_shared_legend}.
ggplot2 objects have their legends hidden.}

\item{ncol}{Integer, number of columns to arrange plots in.}

\item{nrow}{Integer, number of rows to arrange plots in.}

\item{position}{'bottom' or 'right' for positioning legend.}

\item{plot}{Logical, when \code{TRUE} (default), draws combined plot on a
new page.}
}
\value{
gtable of combined plot, invisibly. 
  Draw  gtable object using \code{\link[grid]{grid.draw}}.
}
\description{
Extract legend, combines plots using \code{\link[gridExtra]{arrangeGrob}} / 
\code{grid.arrange},
and places legend in a margin.
}
\examples{
library(ggplot2)
dsamp <- diamonds[sample(nrow(diamonds), 300), ]
p1 <- qplot(carat, price, data = dsamp, colour = clarity)
p2 <- qplot(cut, price, data = dsamp, colour = clarity)
p3 <- qplot(color, price, data = dsamp, colour = clarity)
p4 <- qplot(depth, price, data = dsamp, colour = clarity)
grid_arrange_shared_legend(p1, p2, p3, p4, ncol = 4, nrow = 1)
grid_arrange_shared_legend(p1, p2, p3, p4, ncol = 2, nrow = 2)

# Passing on plots in a grob are not touched
grid_arrange_shared_legend(p1, gridExtra::arrangeGrob(p2, p3, p4, ncol=3), ncol=1, nrow=2)

# We can also pass on named arguments to arrangeGrob:
title <- grid::textGrob('This is grob', gp=grid::gpar(fontsize=14, fontface='bold'))
nt <- theme(legend.position='none')
grid_arrange_shared_legend(p1, 
   gridExtra::arrangeGrob(p2+nt, p3+nt, p4+nt, ncol=3), ncol=1, nrow=2, 
   top=title)
}
\seealso{
\code{\link{g_legend}}, \code{\link{reposition_legend}}
}
\author{
Originally brought to you by
  \href{http://baptiste.github.io/}{Baptiste Auguié} 
  (\url{https://github.com/tidyverse/ggplot2/wiki/Share-a-legend-between-two-ggplot2-graphs})
  and 
  \href{http://rpubs.com/sjackman}{Shaun Jackman}
  (\href{http://rpubs.com/sjackman/grid_arrange_shared_legend}{original}).   
  Stefan McKinnon Edwards added left and top margins.
}
