% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.r
\name{.dot}
\alias{.dot}
\alias{.dot2}
\title{Create paths that are safe from changing working directory.}
\usage{
.dot(x, root = getwd(), mustExist = FALSE, relative = FALSE,
  create = TRUE)

.dot2(names, quiet = FALSE, ...)
}
\arguments{
\item{x}{File path that is appended to \code{BASEDIR}.}

\item{root}{Root of your working directory, 
from which \code{x} is relative too.}

\item{mustExist}{Logical value; if \code{TRUE} and the resulting path does
not exist, it raises an error.}

\item{relative}{For \code{.dot}, sets default for the returned function.
For the returned function, when \code{TRUE}, the function
returns a path relative to \code{root}.}

\item{create}{Logical values, creates the target directory when \code{TRUE} (default).}

\item{names}{Character vector of names}

\item{quiet}{Logical value, suppresses output to stdout() when \code{TRUE}.}

\item{...}{Arguments passed on to \code{.dot}.}
}
\value{
A function that returns file paths constructed from 
        \code{root}, \code{x}, and \code{...}.
        
        \emph{Side effect:} It creates the directory.
}
\description{
The \code{.dot} functions creates functions that allows relative-like 
specification of paths, but are safe from changing working directory.
}
\examples{

.data <- .dot('data')
.data('input.txt')
.data(c('a.txt','b.txt'))

.dot2(c('rawdata','results'))
.rawdata('rawfile.csv')
.results('myresults.txt')
}
