% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_accum_cost.R
\name{create_accum_cost}
\alias{create_accum_cost}
\title{creates an accumulated cost surface}
\usage{
create_accum_cost(
  x,
  origins,
  FUN = mean,
  rescale = FALSE,
  check_locations = FALSE
)
}
\arguments{
\item{x}{\code{SpatRaster}}

\item{origins}{\code{sf} 'POINT' or 'MULTIPOINT', \code{SpatVector}, \code{data.frame} or \code{matrix} containing the origins coordinates. If multiple origins are supplied then the multiple accumulated cost surfaces will be summarised using the FUN argument}

\item{FUN}{\code{function} Apply a function to the cells of a SpatRaster. Default applied function is 'mean'. See terra::app() for more information}

\item{rescale}{\code{logical}. if TRUE, values scaled to between 0 and 1. FALSE (default)}

\item{check_locations}{\code{logical} if TRUE checks if origins are traversable. FALSE (default)}
}
\value{
\code{SpatRaster}
}
\description{
Creates an accumulated cost surfaces from one or more origins
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
sf::st_point(c(907695, 4145478)),
crs = terra::crs(r)))

cc <- create_accum_cost(x = slope_cs, origins = locs, FUN = mean, rescale = FALSE)
}
\author{
Joseph Lewis
}
