% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_matrix.R
\name{cost_matrix}
\alias{cost_matrix}
\title{Create a cost based nearest neighbour matrix}
\usage{
cost_matrix(cost_surface, locations, k)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} object (gdistance package). Cost surface to be used in calculating the k nearest neighbour}

\item{locations}{\code{SpatialPoints}. Locations to calculate k nearest neighbours from}

\item{k}{\code{numeric} number of nearest neighbours to be returned}
}
\value{
\code{matrix} cost-based k nearest neighbour for each location as specified in the locations argument. The resultant \code{matrix} can be used in the nb_matrix argument within the create_lcp_network function.
}
\description{
Creates a cost based nearest neighbour matrix of k length for each provided location. This matrix can be used in the nb_matrix argument within the create_lcp_network function to calculate Least Cost Paths between origins and destinations.
}
\examples{

r <- raster::raster(nrow=50, ncol=50,  xmn=0, xmx=50, ymn=0, ymx=50,
crs='+proj=utm')

r[] <- stats::runif(1:length(r))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

locs <- sp::spsample(as(raster::extent(r), 'SpatialPolygons'),n=5,'regular')

matrix <- cost_matrix(slope_cs, locs, 2)

lcp_network <- create_lcp_network(slope_cs, locations = locs,
nb_matrix = matrix, cost_distance = FALSE, parallel = FALSE)
}
\author{
Joseph Lewis
}
