% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cost_corridor.R
\name{create_cost_corridor}
\alias{create_cost_corridor}
\title{create_cost_corridor}
\usage{
create_cost_corridor(cost_surface, origin, destination, rescale = FALSE)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} object (gdistance package). Cost surface to be used in Cost Corridor calculation}

\item{origin}{\code{SpatialPoints}. orgin location from which the Accumulated Cost is calculated. Only the first cell is taken into account.}

\item{destination}{\code{SpatialPoints}. destination location from which the Accumulated Cost is calculated. Only the first cell is taken into account}

\item{rescale}{if TRUE raster values scaled to between 0 and 1. Default is FALSE}
}
\value{
RasterLayer object

\code{RasterLayer} (raster package). The resultant object is the accumulated cost surface from origin-to-destination and destination-to-origin and can be used to identify areas of preferential movement in the landscape.
}
\description{
Creates a Cost Corridor raster object
}
\details{
Combines the accumulated cost surfaces from origin-to-destination and destination-to-origin to identify areas of preferential movement that takes into account both directions of movement.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))
slope_cs <- create_slope_cs(r, cost_function = 'tobler', neighbours = 16)

loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

loc2 = cbind(2667800, 6479400)
loc2 = sp::SpatialPoints(loc2)

cost_corridor <- create_cost_corridor(slope_cs, loc1, loc2, rescale = FALSE)
}
\author{
Joseph Lewis
}
