% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_FETE_lcps.R
\name{create_FETE_lcps}
\alias{create_FETE_lcps}
\title{create_FETE_lcps}
\usage{
create_FETE_lcps(cost_surface, locations, cost_distance = FALSE,
  parallel = FALSE)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} object (gdistance package). Cost surface to be used in Least Cost Path calculation.}

\item{locations}{\code{SpatialPoints}. Locations to calculate Least Cost Paths from and to.}

\item{cost_distance}{if TRUE computes total accumulated cost for each Least Cost Path. Default is FALSE.}

\item{parallel}{if TRUE, the Least Cost Paths will be calculated in parallel. Number of Parallel socket clusters is total number of cores available minus 1. Default is FALSE.}
}
\value{
\code{SpatialLinesDataFrame} (sp package). The resultant object contains least cost paths calculated from each location to all other locations.
}
\description{
Calculates least cost paths from each location to all other locations.
}
\details{
Computes least cost paths from each location to all other locations (i.e. From Everywhere To Everywhere (FETE)). This is based on the method proposed by White and Barber (2012).
}
\examples{

r <- raster::raster(nrow=50, ncol=50,  xmn=0, xmx=50, ymn=0, ymx=50,
crs='+proj=utm')

r[] <- stats::runif(1:length(r))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

locs <- sp::spsample(as(r, 'SpatialPolygons'),n=5,'regular')

lcp_network <- create_FETE_lcps(cost_surface = slope_cs, locations = locs,
cost_distance = FALSE, parallel = FALSE)
}
\author{
Joseph Lewis
}
