% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_radio.R
\name{question_radio}
\alias{question_radio}
\title{Radio question}
\usage{
question_radio(
  text,
  ...,
  correct = "Correct!",
  incorrect = "Incorrect",
  try_again = incorrect,
  allow_retry = FALSE,
  random_answer_order = FALSE
)
}
\arguments{
\item{text}{Question or option text}

\item{...}{answers and extra parameters passed onto \code{\link{question}}.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{FALSE}.}

\item{try_again}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{TRUE}.}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{random_answer_order}{Display answers in a random order.}
}
\description{
Creates a radio button tutorial quiz question.  The student can select only
one radio button before submitting their answer.
}
\details{
Note: Multiple correct answers are allowed.
}
\examples{
question_radio(
  "Pick the letter B",
  answer("A"),
  answer("B", correct = TRUE),
  answer("C"),
  answer("D"),
  allow_retry = TRUE,
  random_answer_order = TRUE
)
}
\seealso{
\code{\link{question_checkbox}}, \code{\link{question_text}}
}
