% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-simplegraticule.R
\name{addSimpleGraticule}
\alias{addSimpleGraticule}
\title{Add a simple Graticule on the map
see \url{https://github.com/ablakey/Leaflet.SimpleGraticule}}
\usage{
addSimpleGraticule(map, interval = 20, showOriginLabel = TRUE,
  redraw = "move", hidden = FALSE, zoomIntervals = list(),
  layerId = NULL, group = NULL)
}
\arguments{
\item{map}{a map widget object}

\item{interval}{The spacing in map units between horizontal and vertical lines.}

\item{showOriginLabel}{true Whether or not to show '(0,0)' at the origin.}

\item{redraw}{on which map event to redraw the graticule. On move is default but moveend can be smoother.}

\item{hidden}{hide on start}

\item{zoomIntervals}{use different intervals in different zoom levels. If not specified, all zoom levels use value in interval option.}

\item{layerId}{the layer id}

\item{group}{the name of the group this layer belongs to.}
}
\description{
Add a simple Graticule on the map
see \url{https://github.com/ablakey/Leaflet.SimpleGraticule}
}
\examples{
library(leaflet)

leaflet() \%>\%
  addTiles() \%>\%
  addSimpleGraticule()

}

